{{-- resources/views/peninjauan/partials/edit-tab-ba-kesaksian.blade.php --}}

<!-- BA Kesaksian Tab -->
<div class="tab-pane fade show active" id="ba-kesaksian" role="tabpanel">
    <div class="card">
        <div class="card-header">
            BA Kesaksian
        </div>
        <div class="card-body">
            <!-- BA Kesaksian Section -->

            <div class="row mb-3">
                <div class="col-6">
                    <div class="form-group">
                        <label for="ba_tanggal">Tanggal</label>
                        <input type="date" class="form-control" id="ba_tanggal" name="ba_tanggal"
                               value="{{ old('ba_tanggal', $peninjauan->ba_tanggal ? \Carbon\Carbon::parse($peninjauan->ba_tanggal)->format('Y-m-d') : '') }}" required>
                        @error('ba_tanggal')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label for="nomor_ba_kesaksian">Nomor BA Kesaksian</label>
                        <input type="text" class="form-control" id="nomor_ba_kesaksian" name="nomor_ba_kesaksian"
                               value="{{ old('nomor_ba_kesaksian', $peninjauan->nomor_ba_kesaksian) }}"
                               placeholder="generate otomatis" readonly>
                        @error('nomor_ba_kesaksian')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>


            <!-- Saksi 1 Section -->
            <h5 class="section-title">Saksi 1</h5>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="saksi1_nama">Nama</label>
                        <input type="text" class="form-control" id="saksi1_nama" name="saksi1_nama"
                               value="{{ old('saksi1_nama', $peninjauan->saksi1_nama) }}"
                               placeholder="Nama lengkap saksi 1" required>
                        @error('saksi1_nama')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="saksi1_ttl">Tempat/Tgl Lahir</label>
                        <input type="text" class="form-control" id="saksi1_ttl" name="saksi1_ttl"
                               value="{{ old('saksi1_ttl', $peninjauan->saksi1_ttl) }}"
                               placeholder="Tempat, tanggal lahir">
                        @error('saksi1_ttl')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="saksi1_pekerjaan">Pekerjaan</label>
                        <input type="text" class="form-control" id="saksi1_pekerjaan" name="saksi1_pekerjaan"
                               value="{{ old('saksi1_pekerjaan', $peninjauan->saksi1_pekerjaan) }}"
                               placeholder="Pekerjaan">
                        @error('saksi1_pekerjaan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="saksi1_alamat">Alamat</label>
                        <textarea class="form-control" id="saksi1_alamat" name="saksi1_alamat" rows="2"
                                  placeholder="Alamat lengkap">{{ old('saksi1_alamat', $peninjauan->saksi1_alamat) }}</textarea>
                        @error('saksi1_alamat')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Saksi 2 Section -->
            <h5 class="section-title">Saksi 2</h5>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="saksi2_nama">Nama</label>
                        <input type="text" class="form-control" id="saksi2_nama" name="saksi2_nama"
                               value="{{ old('saksi2_nama', $peninjauan->saksi2_nama) }}"
                               placeholder="Nama lengkap saksi 2" required>
                        @error('saksi2_nama')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="saksi2_ttl">Tempat/Tgl Lahir</label>
                        <input type="text" class="form-control" id="saksi2_ttl" name="saksi2_ttl"
                               value="{{ old('saksi2_ttl', $peninjauan->saksi2_ttl) }}"
                               placeholder="Tempat, tanggal lahir">
                        @error('saksi2_ttl')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="saksi2_pekerjaan">Pekerjaan</label>
                        <input type="text" class="form-control" id="saksi2_pekerjaan" name="saksi2_pekerjaan"
                               value="{{ old('saksi2_pekerjaan', $peninjauan->saksi2_pekerjaan) }}"
                               placeholder="Pekerjaan">
                        @error('saksi2_pekerjaan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="saksi2_alamat">Alamat</label>
                        <textarea class="form-control" id="saksi2_alamat" name="saksi2_alamat" rows="2"
                                  placeholder="Alamat lengkap">{{ old('saksi2_alamat', $peninjauan->saksi2_alamat) }}</textarea>
                        @error('saksi2_alamat')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>
        </div>
        <!-- Form Actions -->
        <div class="card-footer d-flex justify-content-between">
            {{-- <button type="button" class="btn btn-secondary" onclick="saveDraft()">
                Simpan Draft
            </button>
            <button type="button" class="btn btn-primary" onclick="nextTab()">
                Selanjutnya
            </button> --}}
        </div>
    </div>
</div>
